/*------------------------------------------------------------------
		Basic atomic C type definitions
		-------------------------------

	(C) Silicon Dream Ltd 1994

  ------------------------------------------------------------------

Changes:						Date:
* Created file						17/08/94
*/

#ifndef ATOMIC
#define ATOMIC

/* Atomic type definitions */

#define byte		unsigned char	/* by */
#define ushort		unsigned short	/* us */
#define ulong		unsigned long	/* ul */
#define bool		ushort		/* b */
#define fpoint		long		/* fp */

/* General definitions */

#define _st		static
#ifdef _MSC_VER
#ifndef _WIN32		// 16 bit MSVC++
#define _dyn		_export _far _pascal _loadds	// Used for static linked C DLL entry points
#define _getdyn		_export _far _cdecl _loadds	// Used for 'GetProcAddress' linked C DLL entry points
#define _cppdyn		_export _far			// Used for C++ DLL entry points
#define _exp		_export _far			// Used for App callback (MakeProcInstance
#endif _WIN32						//			  sets up DS)
#ifdef _WIN32		// 32 bit MSVC++
#define _dyn		__declspec(dllexport)
#define _getdyn		__declspec(dllexport)
#define _cppdyn		__declspec(dllexport)
#define _exp
#endif _WIN32
#endif _MSC_VER
#ifndef _MSC_VER	// Other
#define _dyn		_export
#define _getdyn		_export
#define _cppdyn		_export
#define _exp		_export
#endif _MSC_VER
#define FALSE		0
#define TRUE		1
#ifndef USHRT_MAX
#define USHRT_MAX	0xFFFF
#endif
#ifndef ULONG_MAX
#define ULONG_MAX	0xFFFFFFFF
#endif
#define FLT_MAX		1E+37

/* Use the following for accessing parts of a 16.16 fixed point number */

#define WHOLE_PART(x)		(((short *) &(x))[1])
#define FRAC_PART(x)		(((ushort *) &(x))[0])
#define FLOAT2FP(x)		((long) ((x)*65536))
#define SHORT2FP(x)		(((long) (x))<<16)
#define LONG2FP(x)		((x)<<16)
#define FP2FLOAT(x)		(((float) (x))/65536)

/* Use AfxExt(dllname) if you want to use the DLL version of the MFC (_AFXDLL)
   from within a DLL (ie. an MFC extension DLL). It implements the neccessary
   DLL initialisation entry piont procedure */

#define AfxExt(dllname)	static AFX_EXTENSION_MODULE dllname##DLL={NULL, NULL}; \
	static HINSTANCE hinst;\
	extern "C" int APIENTRY DllMain(HINSTANCE hinstIn, DWORD dwReason, LPVOID pvReserved) \
		{ \
		hinst=hinstIn; \
		if (dwReason==DLL_PROCESS_ATTACH) \
			{ \
			TRACE0(#dllname".DLL Initializing!\n"); \
			AfxInitExtensionModule(dllname##DLL, hinst); \
			new CDynLinkLibrary(dllname##DLL); \
			} \
		else if (dwReason==DLL_PROCESS_DETACH) \
			{ \
			TRACE0(#dllname".DLL Terminating!\n"); \
			} \
		return 1; \
		}
#endif			// Do not include this file twice
